﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Generate Unique Id step.
    /// </summary>
    public class GenerateUniqueIdStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {
            try
            {
                state.PatientRequestUniqueId = RandomDigits.GetRandomDigitString(20);
                state.ProviderRequestUniqueId = RandomDigits.GetRandomDigitString(20);
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults GenerateUniqueIdStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}